* Author: Dr. Jrg Michael Mller, Uni Tbingen, 07071-2978353;
* Adress: Friedrichstrasse 21, 72072 Tbingen, Germany
* Email: JMMueller@uni-tuebingen.de
* 1. Website: http://www.JoergMMueller.de/default.htm
* 2. Website: http://www.psychological-tests.de
*
* Content: SAS-Macro to compute the PDTS and PDPP score of a psychological test;
* Additional information about the macro could be retrieved from the following papers:
*
* Reference: PLEASE CITE IF YOU USE THE PROGRAM: 
* Mller, J. M. (2004). SAS MACROS TO COMPUTE THE PROBABILITY OF DISTINCT TEST RESULTS. Psychological Research Online. 
* Mller, J. M. (2004). PROBABILITY OF DISTINCT TEST RESULTS. A basic test attribute. Psychological Research Online.
* 
* Table of Contents:
* Name of Macro					* Function:
*******************************************************************************************;
* %Log_on	%Log_on 			* Enable/Disable the SAS-Log
* %mac_on	%mac_on				* Enable/Disable SAS-Macro statements in the Log
* %ReadWinPP(filepath); 		* Rearrange the SPSS-Winmira output file;
* %ReadBigPP(filepath); 		* Read the output of Bigsteps (NOTE that it reads the *.pf file, that could be requested by Bigsteps-statements;
* %ReadParPP(filepath); 		* Read the Parscale output *.ph3;
* %ReadBilPP(filepath); 		* Read the Bilog-MG output *.ph3;
* %PDPP(FILE, PERSPARA, SEM);	* Compute the PDPP;
* %PDTS(FILE, RELI, SCORE);		* Compute the PDTS;
* The invoking macro calls are given next for the example input files:
/*
%ReadBilPP(YOURPATH\Bil_test.PH3)
%PDPP(file, PERSPARA, SEM)
%ReadParPP(YOURPATH\Par_test.ph3)
%PDPP(file, PERSPARA, SEM)
%ReadBigPP(YOURPATH\Big_test.pf)
%PDPP(file, PERSPARA, SEM)
%ReadWinPP(YOURPATH\Win_test.por)
%PDPP(file, PERSPARA, SEM)
%PDTS(file, 81, perspara)
*/
* To have an example for the PDTS macro, please make the permanent 
* SASfile 'sas_test.sas7bdat' actual in your Work-library, e.g. by an libname statement;

%macro log_on;
options source notes date;
%mend log_on;
%macro log_off;
options nosource nonotes nodate;
%mend log_off;
%macro mac_on;
options mprint merror mlogic serror symbolgen;
%mend mac_on;
%macro mac_off;
options  nomlogic nomprint nomerror nosymbolgen nomrecall;
%mend mac_off;

%log_off
%mac_off

%macro ReadWinPP(filepath);
		filename f "&filepath";
		proc convert spss=f out=file1;
		data file; set file1; 
		if PERSPARA=.  then delete;
		if STDERR=.    then delete;
		rename STDERR=SEM; run;
%mend ReadWinPP;

%macro ReadBigPP(filepath);
data file1;
	infile "&filepath";
	input perspara 8-14 SEM 31-38; run;
data file2; set file1;
	if SEM>100 then SEM=.;
	if Perspara>100 then delete;
	proc means noprint;var SEM; output out=out max=SEMmax;  run;
data zwisch; set out;
	SEMmax=10000*SEMMAX;
	call symput('SEMmax',SEMmax); run;
data file (drop=SEMmax); set file2;
	SEMmax=0.00017* &SEMmax;
    if SEM=. then SEM=SEMmax;
%mend ReadBigPP;

%macro ReadParPP(filepath);
data file1;
	infile "&filepath";
	input @'1              1' @56 perspara SEM /; run;
data file2; set file1;
	if SEM>100 then SEM=.;
	if Perspara>100 then delete;
	proc means noprint; var SEM; output out=out max=SEMmax;  run;
data zwisch; set out;
	SEMmax=10000*SEMMAX;
	call symput('SEMmax',SEMmax); run;
data file (drop=SEMmax); set file2;
	SEMmax=0.00017* &SEMmax;
    if SEM=. then SEM=SEMmax; run;
%mend ReadParPP;

%macro ReadBilPP(filepath);
	data file1;
	infile "&filepath";
	input @'1.00   TEST' @44 Perspara SEM /;
data file2; set file1;
	if SEM>100 then SEM=.;
	proc means noprint;var SEM; output out=out max=SEMmax;  run;
data zwisch; set out;
	SEMmax=10000*SEMMAX;
	call symput('SEMmax',SEMmax); run;
data file (drop=SEMmax); set file2;
	SEMmax=0.00017* &SEMmax;
    if SEM=. then SEM=SEMmax; run;
%mend ReadBilPP;
 
%macro content2(datain, charnum);
%global vmax obs;
data d1; set macro.&datain;
call symput('obs',left(_n_)); run;
proc contents data=macro.&datain noprint out=d2;
%if &charnum=1 %then %do; data d3; set d2; where type=1; %end;
%if &charnum=2 %then %do; data d3; set d2; where type=2; %end;
%if &charnum=3 %then %do; data d3; set d2; %end;
call symput('vmax',left(_n_)); run;
data d4; set d3;
%do i= 1 %to &vmax; %global v&i l&i t&i f&i; %end;
call symput('v'||left(_n_), name);
call symput('l'||left(_n_), label);
call symput('t'||left(_n_), type);
call symput('f'||left(_n_), format);
call symput('p'||left(_n_), npos);
run cancel;
%mend content2;

%macro PDPP(file, PERSPARA, SEM);
* Der Datensatz wird reduziert auf die PP und gedreht;
data macro.p1; set &file(keep=&PERSPARA ); run;

* Jetzt muss die Anzahl der Beobachtungen eingelesen werden;
%content2(p1,3)
proc transpose data=macro.p1 out=macro.pg1 prefix=p;  run;
data macro.pg2; set macro.pg1(drop=_NAME_);

* ebenfalls wird der Datensatz reduziert auf die Fehlervarianz und gedreht;
data macro.e1; set &file(keep=&SEM ); 
	proc transpose data=macro.e1 out=macro.eg1 prefix=e;  run;

data macro.eg2; set macro.eg1(drop=_NAME_);
* nun mssen die beiden  Dateien miteinander verbunden werden;
* und die Arrays festgelegt werden, die einen schnellen vollstndigen Vergleich der PP erlauben;
data macro.pe; merge macro.pg2 macro.eg2;
	array a{*} p1-p&obs;
	array b{*} p1-p&obs;
	array c{*} e1-e&obs;
	array d{*} e1-e&obs;
	EPU=0;
	TPU=0;
* Jetzt kann der Vergleich PP1PP2 > kritische Differenz in einem sehr langen file erfolgen;
do i= 1   to &obs;
	do j= i+1 to &obs;
	ppk=1.96*sqrt(c{i} + d{j});
	ppd=      abs(a{i} - b{j});
	* Jetzt wird ausgezhlt;
	if ppd > ppk then EPU=EPU+1;
					  TPU=TPU+1;
	end;
end;

data raus; set macro.pe(drop=p1-p&obs e1-e&obs);
	call symput('EPU', EPU);
	call symput('TPU', TPU);
data IRTPDR; set macro.pe;
	Scale="&file";
	PDPP=( &EPU/ &TPU )*100;
	Personen=&obs;
	proc print round; var scale personen PDPP;
	title1 "Your test &file ";
	title2 "shows a probability to distinguishing two randomly"; 
	title3 "selected person parameter of ... (see PDPP in %)"; run;
	title1; 	title2; 	title3; 	run;
%mend PDPP;

%ReadBilPP(D:\Habil\Artikel\PDTS\Makros\Bil_test.PH3)
%PDPP(file, PERSPARA, SEM)
%ReadParPP(D:\Habil\Artikel\PDTS\Makros\Par_test.ph3)
%PDPP(file, PERSPARA, SEM)
%ReadBigPP(D:\Habil\Artikel\PDTS\Makros\Big_test.pf)
%PDPP(file, PERSPARA, SEM)
%ReadWinPP(D:\Habil\Artikel\PDTS\Makros\Win_test.por)
%PDPP(file, PERSPARA, SEM)

%macro PDTS(FILE, reli, score);
data &score; set &FILE (keep=&score);
	title1; title2; title3; if &score=. then delete; run;
data d1; set &score; call symput('frq',left(_n_));
data _null_; set d1; %let TPU=%eval((&frq * (&frq -1))/2); run;
proc means data=&score noprint; var &score; output out=o std= s;
data _null_; set o; call symput("s",s); run;
data d2; set &score;
	reli=&reli/100;
	krit= 1.96 * (&s * (sqrt (2 * (1-(&reli/100)))));
data d3; set d2;
	call symput ('krit', krit); run;
	proc transpose data=&score out=ot prefix=v;  run;
data d4; set ot;
	array a{*} v1-v&frq;
	array b{*} v1-v&frq;
	EPU=0;
	krit=abs(&krit);
	do i= 1 to &frq;
		do j= i+1 to &frq;
		diff=abs(a{i} - b{j});
		if diff > krit then EPU=EPU+1;
		end;
	end;
data fertig; set d4;
	TPU=&TPU; PDTS=(EPU/TPU)*100; reli=&reli/100; Personen=&frq;
	proc print round; var personen krit reli PDTS;
	title1 "Your test &file ";
	title2 "shows a probability to distinguishing"; 
	title3 "two randomly selected person parameter of PDTS(in %)"; run;
	title1; 	title2; 	title3; run;
%mend PDTS;

%PDTS(file, 81, perspara)